<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo e(config('app.name')); ?></title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/animations.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/simple-notify.min.css')); ?>" />
    <link href='https://fonts.googleapis.com/css?family=Varela+Round' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" crossorigin="anonymous">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/simple-notify.min.js')); ?>"></script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>

    <style>
    body {
        font-family: 'Nunito', sans-serif;
    }
    </style>
</head>

<body class="">
<?php echo $__env->make('flash-messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="container-fluid header">
        <div class="container">
            <img src="<?php echo e(asset('img/logo.png')); ?>" height="50" width="auto" alt="Logo" class="logo mt-0">
            <ul class="desktop-menu d-none d-lg-inline-block">
                <li><a href="<?php echo e(route('welcome')); ?>">Home</a></li>
                <li><a href="<?php echo e(route('login')); ?>">Faucet</a></li>
                <li><a href="<?php echo e(route('login')); ?>">Shortlinks</a></li>
                <li><a href="<?php echo e(route('login')); ?>">Staking</a></li>
            </ul>
            <div class="navbar ml-4">
                <a href="<?php echo e(route('login')); ?>" class="login">
                    <p>SIGN IN</p>
                </a>
                <a href="<?php echo e(route('register')); ?>" class="register">
                    <p>SIGN UP</p>
                </a>
            </div>
        </div>
    </div>
    <div class="slider">
        <div class="background-mountains">
            <div class="images">
            <svg style="position: absolute;
    left: 0;
    min-width: 100%;bottom:-10%;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320"><path fill="#141c40" fill-opacity="0.8" d="M0,224L24,197.3C48,171,96,117,144,122.7C192,128,240,192,288,218.7C336,245,384,235,432,224C480,213,528,203,576,192C624,181,672,171,720,176C768,181,816,203,864,197.3C912,192,960,160,1008,154.7C1056,149,1104,171,1152,176C1200,181,1248,171,1296,154.7C1344,139,1392,117,1416,106.7L1440,96L1440,320L1416,320C1392,320,1344,320,1296,320C1248,320,1200,320,1152,320C1104,320,1056,320,1008,320C960,320,912,320,864,320C816,320,768,320,720,320C672,320,624,320,576,320C528,320,480,320,432,320C384,320,336,320,288,320C240,320,192,320,144,320C96,320,48,320,24,320L0,320Z"></path></svg>
            </div>
            <div class="container">
                <h1 class="bounce"><strong>EARN FREE CRYPTOS</strong></h1>
                <div class="heading-line">
                    <span class="short-line"></span>
                    <span class="long-line"></span>
                </div>
                <h2>Different types of cryptocurrency, instant payment!</h2>
                <div class="coins">
                    <p><i class="fab fa-btc"></i>BITCOIN</p>
                    <p><i class="fab fa-ethereum"></i>ETHEREUM</p>
                    <p><i class="fa fa-star"></i>AND MORE COIN</p>
                </div>
                <div class="get-started">
                    <p class="welcome">Open the door now to the crypto world<br>to start collecting free coins and play
                        wonderful games!</p>
                    <a href="<?php echo e(route('login')); ?>" class="login">
                        <p>SIGN IN</p>
                    </a>
                    <a href="<?php echo e(route('register')); ?>" class="register pulse">
                        <p>GET STARTED</p>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="container features">
        <p class="p-title">There are various</p>
        <h3>Ways of earning</h3>
        <div class="heading-line">
            <span class="short-line"></span>
            <span class="long-line"></span>
        </div>
        <div class="row list">
            <div class="col item fadeIn" id="fadeIn">
                <img src="/images/faucet.png" class="mt-4" alt="">
                <p class="title">Faucet</p>
                <p class="description">Place your claim, raise your crypto fortune! Get an access to all currencies in
                    one tab with our Auto Claim faucet! </p>
            </div>
            <div class="col item fadeIn" id="fadeIn">
                <img src="/images/link.png" class="mt-4" alt="">
                <p class="title">Shortlink</p>
                <p class="description">Start to earn energy to use this energy in the autofaucet area, so you can earn coins!</p>
            </div>
            <div class="col item fadeIn" id="fadeIn">
                <img src="/images/stake.png" class="mt-4" alt="">
                <p class="title">Staking</p>
                <p class="description">Keep your coins in your balance and start to receive daily interest in your balance account!</p>
            </div>
        </div>
    </div>
    <div class="container-fluid fea-details">
        <div class="container content">
            <p class="p-title">We provide</p>
            <h3>Great Features</h3>
            <div class="heading-line">
                <span class="short-line"></span>
                <span class="long-line"></span>
            </div>
            <div class="row list">
                <div class="col item" id="slideRight">
                    <div class="icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <p class="title">20% Referral Bonus</p>
                    <p class="description">By referring our website, you can get lifetime 20% commission everytime they
                        claim!</p>
                </div>
                <div class="col item" id="slideLeft">
                    <div class="icon">
                        <i class="fas fa-money-bill-alt"></i>
                    </div>
                    <p class="title">Instant Withdraw</p>
                    <p class="description">You can get your earnings without waiting, furthermore in various ways of
                        withdrawal options.</p>
                </div>
                <div class="w-100"></div>
                <div class="col item" id="slideRight">
                    <div class="icon">
                        <i class="fas fa-level-up-alt"></i>
                    </div>
                    <p class="title">Level Up, Increase Your Earnings</p>
                    <p class="description">You can get more earnings by leveling up with a simple way.</p>
                </div>
                <div class="col item" id="slideLeft">
                    <div class="icon">
                        <i class="fas fa-coins"></i>
                    </div>
                    <p class="title">Various Types of Currencies</p>
                    <p class="description">We are supplying many types of cryptocurrencies and the new types are on the
                        way!</p>
                </div>
                <div class="w-100"></div>
                <div class="col item" id="slideRight">
                    <div class="icon">
                        <i class="fas fa-exchange-alt"></i>
                    </div>
                    <p class="title">Instant Exchange</p>
                    <p class="description">Enjoy the comfort of instant exchange under very low fees.</p>
                </div>
                <div class="col item" id="slideLeft">
                    <div class="icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <p class="title">Direct Support</p>
                    <p class="description">Get direct support by creating a ticket, we are only one click away.</p>
                </div>
            </div>
        </div>
    </div>
    <!--<div class="container-fluid stats">
        <div class="container">
            <div class="row">
                <div class="col">
                    <p class="title">Registered Users</p>
                    <p class="content">0+</p>
                </div>
                <div class="col">
                    <p class="title">Total Withdrawals</p>
                    <p class="content">0+</p>
                </div>
                <div class="col">
                    <p class="title">Faucet Claims</p>
                    <p class="content">0+</p>
                </div>
            </div>
        </div>
    </div> -->
    <div class="container-fluid footer">
        <div class="container">
            <div class="row">
                <div class="col" id="slideRight">
                    <img src="<?php echo e(asset('img/logo.png')); ?>" height="40" width="auto" alt="Logo" class="logo">
                    <p class="comp-desc">We are one of the most reliable faucet websites all over the world. We are
                        providing our free services.</p>
                </div>
                <div class="col" id="slideUp">
                    <p class="title">SERVICES &amp; MORE</p>
                    <ul class="footer-menu">
                        <li><a href="<?php echo e(route('login')); ?>">Shortlinks</a></li>
                        <li><a href="<?php echo e(route('login')); ?>">Autofaucet</a></li>
                    </ul>
                </div>
                <div class="col" id="slideLeft">
                    <p class="title">Get social</p>
                    <div class="social-box">
                        <a href="https://twitter.com/" target="_blank" rel="nofollow noopener noreferrer">
                            <i class="fab fa-twitter twitter"></i>
                        </a>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col">
                    <p class="copyright">Copyright © 2021 - <?php echo e(config('app.name')); ?></p>
                </div>
                <div class="col">
                    <p class="terms-conditions">
                        <a href="<?php echo e(route('terms')); ?>">Terms &amp; Conditions</a>
                    </p>
                </div>
            </div>
            <ul></ul>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-Piv4xVNRyMGpqkS2by6br4gNJ7DXjqk09RmUpJ8jgGtD7zP9yug3goQfGII0yAns" crossorigin="anonymous">
    </script>
    <script src="https://js.hcaptcha.com/1/api.js" async defer></script>
</body>

</html><?php /**PATH /home/jorgeserranodev/Escritorio/Projects/timebitco.in/autoclaim/resources/views/welcome.blade.php ENDPATH**/ ?>