<x-app-layout>
    <div>
        <div class="w-content">
            <div class="row page-stats-area">
                <div class="col item">
                    <div class="content-box">
                        <p class="title">Available Balance</p>
                        <p class="amount"><span id="availableBalance">{{ number_format($balance, 8, '.', '') }}</span>
                            {{ strtoupper($coin->short_name) }}</p>
                    </div>
                    <div class="icon-area green">
                        <i class="fas fa-coins icon"></i>
                    </div>
                </div>
                <div class="col item">
                    <div class="content-box">
                        <p class="title">Total Withdrawn</p>
                        <p class="amount"><span id="totalWithdrawn">0.00000000</span>
                            {{ strtoupper($coin->short_name) }}</p>
                    </div>
                    <div class="icon-area red">
                        <i class="fas fa-cube icon"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="m-area">
            <p class="title">Withdraw (<span id="cname">{{ strtoupper($coin->short_name) }}</span>)</p>
            <hr>
            <p class="desc">By filling the form below, you can withdraw your available balance <b>without any minimum
                    amount</b>, furthermore there is <b>no sending fee!</b></p>
            <form name="form-withdraw" id="form-withdraw" action="{{ route('withdraw.store') }}" method="post">
            @csrf
                <div class="form-row form">
                    <div class="col">
                        <label for="processor">Processor</label>
                        <select class="form-control" id="processor" name="processor" required="">
                            <option selected="" disabled="">Select the processor</option>
                            @if($coin->fp_supported == 1)
                            <option value="faucetpay">FaucetPay</option>
                            @endif
                            @if($coin->xp_supported == 1)
                            <option value="expresscrypto">ExpressCrypto</option>
                            @endif
                        </select>
                    </div>
                    <div class="col p-details">
                    </div>
                </div>
                <div class="form-row form">
                    <div class="col">
                        <label for="amount">Amount</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="amount" name="amount" placeholder="0.00000000"
                                aria-describedby="maxwith-addon" required="">
                            <button class="btn btn-light" type="button" id="maxwith-addon">MAX</button>
                        </div>
                    </div>
                    <div class="col">
                        <label for="captcha-select">Captcha</label>
                        <select class="form-control captcha-select" id="captcha-select" name="captcha-select">
                            <option value="hcaptcha">hCaptcha</option>
                        </select>
                    </div>
                </div>
                <div class="form-row form">
                    <div class="col">
                        <div class="h-captcha" data-sitekey="{{$settings[1]->value}}" data-theme="light"></div>
                        <input type="hidden" name="currency" value="{{ $coin->short_name }}">
                        <button type="submit" id="withSub"
                            class="btn btn-primary button float-left mt-25">Withdrawal</button>
                    </div>
                </div>
                <div class="clearfix"></div>
            </form>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <x-footer></x-footer>
    </div>
    <script>
    $("#maxwith-addon").on("click", function() {
        $("#amount").val($("#availableBalance").text());
    });
    </script>
</x-app-layout>