<x-app-layout>
    <div class="transactions">
        <p class="title">Tickets</p>
        <a href="/dashboard/tickets/create">
            <div class="button green">
                <p class="view">Create New Ticket</p>
            </div>
        </a>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Subject</th>
                        <th scope="col">Last updated</th>
                        <th scope="col">Status</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td class="bold">
                            @if($value->last_answer == 'admin' && $value->status == 'open')
                                <span class="badge-warning badge-dot"></span>
                            @endif
                            <a href="{{ route('tickets.show',$value->id) }}">{{ $value->subject }}</a>
                        </td>
                        <td>{{ $value->updated_at }}</td>
                        <td>
                            @if($value->status == 'open')
                                <span class="badge-success badge-dot"></span>
                                <span class="text-capitalize">{{ $value->status }}</span>
                            @else
                                <span class="badge-danger badge-dot"></span>
                                <span class="text-capitalize">{{ $value->status }}</span>
                            @endif
                        </td>
                        <td><a href="{{ route('tickets.show',$value->id) }}" class="btn btn-success">View</a></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
    <x-footer></x-footer>
</x-app-layout>