<x-app-layout>
    <div class="transactions">
        <p class="title">Shortlink History</p>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Shortlink Name</th>
                        <th scope="col">Date</th>
                        <th scope="col">Energy</th>
                        <th scope="col">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($links as $key=>$link)
                        <tr>
                            <th scope="row">#{{ $link->id }}</th>
                            <td>{{ $link->shortlink->name }}</td>
                            <td>{{ $link->created_at }}</td>
                            <td>{{ $link->energy }}</td>
                            <td>
                                @if($link->status == 'pending')
                                    <span class="badge-warning badge-dot"></span>
                                    <span>Pending</span>
                                @elseif($link->status == 'completed')
                                    <span class="badge-success badge-dot"></span>
                                    <span>Completed</span>
                                @elseif($link->status == 'expired')
                                    <span class="badge-danger badge-dot"></span>
                                    <span>Expired</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $links->links() !!}
        </div>

    </div>
    <x-footer></x-footer>
</x-app-layout>