<x-app-layout>
    <div class="">
        <div class="s-area">
            <p class="title-b">Deposit</p>
            <div class="clearfix"></div>
            <ul class="nav nav-tabs sub-area" id="stakings" role="tablist">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('deposit.index') }}">Deposit</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" aria-selected="true" href="{{ route('deposit.history') }}" aria-selected="true"><i
                            class="fas fa-history" style="margin-right: 5px;"></i> History</a>
                </li>
            </ul>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="tab-content withdraw-content" id="referralsContent">
            <div class="tab-pane fade show active" id="staking" role="tabpanel" aria-labelledby="staking-tab">
                <div class="f-area">
                    <p class="title">History</p>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Currency</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $key => $value)
                                    <tr>
                                        <th scope="row">#{{ ++$i }}</th>
                                        <td>{{ number_format($value->amount, 8, '.', '') }} <span class="text-uppercase">{{ $value->currency->short_name }}</span></td>
                                        <td>{{ $value->currency->name }}</td>
                                        <td>{{ $value->created_at }}</td>
                                        <td>
                                            @if($value->status == 'completed')
                                            <span class="badge-success badge-dot"></span>
                                            <span class="text-capitalize">{{$value->status}}</span>
                                            @elseif($value->status == 'pending')
                                            <span class="badge-warning badge-dot"></span>
                                            <span class="text-capitalize">{{$value->status}}</span>
                                            @elseif($value->status == 'expired')
                                            <span class="badge-danger badge-dot"></span>
                                            <span class="text-capitalize">{{$value->status}}</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {!! $data->links() !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="banner d-block d-md-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto">
                <!--banner-->
            </div>
        </div>
        <div class="banner d-none d-md-block d-lg-none text-center m-auto" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <div class="banner d-none d-lg-block text-center" style="margin-top: 30px;">
            <div class="d-inline-block text-center m-auto"></div>
        </div>
        <x-footer></x-footer>
    </div>
</x-app-layout>