<x-app-layout>
    <div class="transactions">
        <p class="title">Tickets</p>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Subject</th>
                        <th scope="col">User</th>
                        <th scope="col">Status</th>
                        <th scope="col">Date</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td class="bold">
                            @if($value->last_answer == 'user' && $value->status == 'open')
                                <span class="badge-warning badge-dot"></span>
                            @endif
                            <a href="{{ route('admin.tickets.show',$value->id) }}">{{ $value->subject }}</a>
                        </td>
                        <td>{{ $value->user->name }}</td>
                        <td>
                            @if($value->status == 'open')
                                <span class="badge-success badge-dot"></span>
                                <span class="text-capitalize">{{ $value->status }}</span>
                            @else
                                <span class="badge-danger badge-dot"></span>
                                <span class="text-capitalize">{{ $value->status }}</span>
                            @endif
                        </td>
                        <td>{{ $value->created_at }}</td>
                        <td>
                            <a class="btn btn-info" href="{{ route('admin.tickets.show',$value->id) }}">View</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
</x-app-layout>