<x-app-layout>
    <div class="transactions">
        <p class="title">Staking Plans</p>
        <a href="{{ route('admin.staking.create') }}">
            <div class="button green">
                <p class="view">Add New Plan</p>
            </div>
        </a>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Name</th>
                        <th scope="col">APY</th>
                        <th scope="col">Days</th>
                        <th scope="col">Currency</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $value)
                    <tr>
                        <th scope="row">#{{ ++$i }}</th>
                        <td>{{ $value->name }}</td>
                        <td>{{ $value->daily_earning*365 }}%</td>
                        <td>{{ $value->duration }}</td>
                        <td>{{ $value->currency->name }}</td>
                        <td>
                            <form action="{{ route('admin.staking.destroy',$value->id) }}" method="POST">
                                <a class="btn btn-primary" href="{{ route('admin.staking.edit',$value->id) }}">Edit</a>
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links() !!}
        </div>

    </div>
</x-app-layout>