<x-app-layout>

    <div class="m-area">
        <p class="title">Edit Shortlink</p>
        <a href="{{ route('admin.shortlinks.index') }}" class="float-right">
        < Back
        </a>
        <hr>

        <form class="mt-5" action="{{ route('admin.shortlinks.update',$shortlink->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-row form">
                <div class="col">
                    <label for="name">Name</label>
                    <input type="text" class="form-control" id="name" name="name" placeholder="Name" value="{{$shortlink->name}}" required=""
                        autocomplete="off">
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="url">URL without end slash "/"</label>
                    <input type="url" class="form-control" id="url" name="url" placeholder="https://shortlink.com" value="{{$shortlink->url}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="api_key">API Key</label>
                    <input type="text" class="form-control" id="api_key" name="api_key" placeholder="API Key" value="{{$shortlink->api_key}}"
                        required="" autocomplete="off">
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="energy">Energy</label>
                    <input type="number" class="form-control" id="energy" name="energy" placeholder="Enter Energy" value="{{$shortlink->energy}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="points">Level points</label>
                    <input type="number" class="form-control" id="points" name="points" placeholder="Enter level points" value="{{$shortlink->points}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="views">Views</label>
                    <input type="number" class="form-control" id="views" name="views" placeholder="Enter Views/Clicks" value="{{$shortlink->views}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="nsfw">Is NSFW</label>
                    <select name="nsfw" class="form-control" id="nsfw">
                        <option value="1" @if($shortlink->nsfw == "1") selected @endif>True</option>
                        <option value="0" @if($shortlink->nsfw == "0") selected @endif >False</option>
                    </select>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12 text-center mt-5">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>

        </form>
    </div>

</x-app-layout>