<x-app-layout>

    <div class="m-area">
        <p class="title">Edit Coin</p>
        <a href="{{ route('admin.coins.index') }}" class="float-right">
        < Back
        </a>
        <hr>

        <form class="mt-5" action="{{ route('admin.coins.update', $coin->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-row form">
                <div class="col">
                    <label for="name">Name</label>
                    <input type="text" class="form-control" id="name" name="name" placeholder="Name" required="" value="{{$coin->name}}"
                        autocomplete="off">
                </div>
                <div class="col">
                    <label for="short_name">Short Name</label>
                    <input type="text" class="form-control" id="short_name" name="short_name" placeholder="Short Name" required="" value="{{$coin->short_name}}"
                        autocomplete="off">
                </div>
                <div class="col">
                    <label for="icon">Icon</label>
                    <input type="text" class="form-control" id="icon" name="icon" placeholder="Icon" required="" value="{{$coin->icon}}"
                        autocomplete="off">
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="withdraw_active">Withdraw Active</label>
                    <select name="withdraw_active" class="form-control" id="withdraw_active">
                        <option value="1" @if($coin->withdraw_active == "1") selected @endif>True</option>
                        <option value="0" @if($coin->withdraw_active == "0") selected @endif>False</option>
                    </select>
                </div>
                <div class="col">
                    <label for="faucet_active">Faucet Active</label>
                    <select name="faucet_active" class="form-control" id="faucet_active">
                        <option value="1" @if($coin->faucet_active == "1") selected @endif>True</option>
                        <option value="0" @if($coin->faucet_active == "0") selected @endif>False</option>
                    </select>
                </div>
                <div class="col">
                    <label for="reward_amount">Reward amount</label>
                    <input type="text" class="form-control" id="reward_amount" name="reward_amount" placeholder="40" value="{{$coin->reward_amount}}"
                        required="" autocomplete="off">
                </div>
                <div class="col">
                    <label for="consume_energy">Consume energy</label>
                    <input type="number" class="form-control" id="consume_energy" name="consume_energy" placeholder="40" value="{{$coin->consume_energy}}"
                        required="" autocomplete="off">
                </div>
            </div>

            <div class="form-row form">
                <div class="col">
                    <label for="fp_supported">FaucetPay Supported</label>
                    <select name="fp_supported" class="form-control" id="fp_supported">
                        <option value="1" @if($coin->fp_supported == "1") selected @endif>True</option>
                        <option value="0" @if($coin->fp_supported == "0") selected @endif>False</option>
                    </select>
                </div>
                <div class="col">
                    <label for="fp_api_key">FaucetPay API Key</label>
                    <input type="text" class="form-control" id="fp_api_key" name="fp_api_key" placeholder="Short Name" required="" value="{{$coin->fp_api_key}}"
                        autocomplete="off">
                </div>
            </div>

            <input type="hidden" name="exchange_active" value="0" />
            <input type="hidden" name="xp_supported" value="0" />
            <input type="hidden" name="xp_api_key" value="test" />
            <input type="hidden" name="xp_user_token" value="test" />

            <div class="col-xs-12 col-sm-12 col-md-12 text-center mt-5">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>

        </form>
    </div>

</x-app-layout>