<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStakingHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staking_histories', function (Blueprint $table) {
            $table->id();
            $table->string('amount');
            $table->string('earnings');
            $table->string('days');
            $table->boolean('status');
            //$table->foreignId('staking_plans_id')->references('id')->on('staking_plans')->onDelete('cascade');
            $table->foreignId('staking_plans_id')->constrained();
            $table->foreignId('user_id')->constrained();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('staking_histories');
    }
}
