<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoinsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coins', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('short_name');
            $table->string('icon');
            $table->boolean('withdraw_active');
            $table->boolean('faucet_active');
            $table->string('reward_amount');
            $table->integer('consume_energy');
            $table->boolean('exchange_active');
            $table->boolean('fp_supported');
            $table->string('fp_api_key');
            $table->boolean('xp_supported');
            $table->string('xp_api_key');
            $table->string('xp_user_token');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coins');
    }
}
