<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\TicketAnswer;

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'subject', 'description', 'status', 'user_id', 'last_answer'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function replies()
    {
        return $this->hasMany(TicketAnswer::class)->orderBy('id', 'desc');
    }

}
