<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Balance;

class Coin extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'short_name', 'icon', 'withdraw_active', 'faucet_active', 'exchange_active', 
        'fp_supported', 'fp_api_key', 'xp_supported', 'xp_api_key', 'xp_user_token', 'reward_amount', 'consume_energy'
    ];

    public function balances()
    {
        return $this->hasMany(Balance::class);
    }

}
