<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StakingPlan;
use App\Models\Coin;

class AdminStakingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = StakingPlan::latest()->paginate(20);
    
        return view('admin.staking.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $coins = Coin::all();
        return view('admin.staking.create',compact('coins'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        StakingPlan::create($request->all());
     
        return redirect()->route('admin.staking.index')
                        ->with('success','Plan added successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(StakingPlan $staking)
    {
        //
        $coins = Coin::all();
        return view('admin.staking.edit',compact('staking', 'coins'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, StakingPlan $staking)
    {
        //
        $staking->update($request->all());
    
        return redirect()->route('admin.staking.index')
                        ->with('success','Plan updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(StakingPlan $staking)
    {
        //
        $staking->delete();
    
        return redirect()->route('admin.staking.index')
                        ->with('success','Plan deleted successfully');
    }
}
