<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Shortlink;

class AdminShortlinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Shortlink::latest()->paginate(20);
    
        return view('admin.shortlinks.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.shortlinks.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'name' => 'required',
            'url' => 'required',
            'api_key' => 'required',
            'points' => 'required',
            'energy' => 'required',
            'views' => 'required',
            'nsfw' => 'required',
        ]);
    
        Shortlink::create($request->all());
     
        return redirect()->route('admin.shortlinks.index')
                        ->with('success','Shortlink added successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Shortlink $shortlink)
    {
        return view('admin.shortlinks.edit',compact('shortlink'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Shortlink $shortlink)
    {
        $request->validate([
            'name' => 'required',
            'url' => 'required',
            'api_key' => 'required',
            'points' => 'required',
            'energy' => 'required',
            'views' => 'required',
            'nsfw' => 'required',
        ]);
    
        $shortlink->update($request->all());
    
        return redirect()->route('admin.shortlinks.index')
                        ->with('success','Shortlink updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Shortlink $shortlink)
    {
        $shortlink->delete();
    
        return redirect()->route('admin.shortlinks.index')
                        ->with('success','Shortlink deleted successfully');
    }
}
