<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Coin;
use App\Models\Balance;
use App\Models\Withdraw;
use App\Models\Settings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $coins = Coin::get()->where('withdraw_active', 1);
        foreach($coins as $coin){
            $coin['wallet'] = Balance::get()->where('user_id', Auth::user()->id)->where('coin_id', $coin->id)->first();
        }

        $data = Withdraw::latest()->where('user_id', '=', Auth::user()->id)->paginate(20);
    
        return view('withdraw.index',compact('coins', 'data'))
                ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($coin)
    {
        //
        $coin = Coin::get()->where('short_name', strtolower($coin))->first();
        $settings = Settings::get();
        if($coin){
            $wallet = Balance::get()->where('user_id', Auth::user()->id)->where('coin_id', $coin->id)->first();
            if($wallet)
                $balance = $wallet->balance;
            else
                $balance = '0.00000000';

            return view('withdraw.create', compact('balance', 'coin', 'settings'));
        }
        else
            return back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'h-captcha-response' => 'required',
            'captcha-select' => 'required',
            'amount' => 'required',
            'processor' => 'required|in:faucetpay,expresscrypto',
            'currency' => 'required',
        ]);

        $requestData = $request->all();
        $amount = $requestData['amount'];

        $hcaptcha_secretkey = Settings::where('name', 'hcaptcha_secret')->first();
        $hcaptcha = verifyHcaptcha($hcaptcha_secretkey->value, $requestData['h-captcha-response']);
     
        if($hcaptcha == 1){

            //Verifications
            if($amount <= 0){
                return redirect()->back()
                                ->with('error','Amount is to less.');
            }

            $coin = Coin::get()->where('short_name', strtolower($requestData['currency']))->first();
            if($coin){
                $wallet = Balance::get()->where('user_id', Auth::user()->id)->where('coin_id', $coin->id)->first();
                if($wallet){
                    if($amount > $wallet->balance)
                        return redirect()->back()
                                ->with('error','Insufficient account balance.');
                }else{
                    return redirect()->back()
                                ->with('error','Insufficient account balance.');
                }
            }else{
                return redirect()->back()
                                ->with('error','Currency not found.');
            }

            if($requestData['processor'] == "faucetpay"){
                $bal = faucetpayBalance($coin->fp_api_key, $coin->short_name);
                if($bal == 0){
                    return redirect()->back()
                                ->with('error','An error was found, try again later.');
                }

                if($bal > $amount){
                    $send = faucetpaySend($coin->fp_api_key, $coin->short_name, $amount*100000000, Auth::user()->faucetpay_acc);
                    if($send == 1){
                        $wallet->balance = $wallet->balance - $amount;
                        $wallet->save();
                        Withdraw::create([
                            'processor' => 'faucetpay', 
                            'amount' => $amount, 
                            'coin_id' =>  $coin->id, 
                            'user_id' => Auth::user()->id, 
                            'status' => 'completed'
                        ]);
                        return redirect()->back()
                                ->with('success','Withdrawal created successfully.');

                    }else{
                        return redirect()->back()
                                ->with('error','The withdrawal cannot be processed, try again later.');
                    }
                }else{
                    return redirect()->back()
                                ->with('error','Insufficient balance in faucetpay.');
                }

            }else if($requestData['processor'] == "expresscrypto"){

            }

        }
        else
            return redirect()->back()
                            ->with('error','Captcha error.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Withdraw  $withdraw
     * @return \Illuminate\Http\Response
     */
    public function show(Withdraw $withdraw)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Withdraw  $withdraw
     * @return \Illuminate\Http\Response
     */
    public function edit(Withdraw $withdraw)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Withdraw  $withdraw
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Withdraw $withdraw)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Withdraw  $withdraw
     * @return \Illuminate\Http\Response
     */
    public function destroy(Withdraw $withdraw)
    {
        //
    }
}
