<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Coin;
use App\Models\Balance;
use App\Models\Settings;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
        //
        $coins = Coin::get();
        $settings = Settings::get();
        foreach($coins as $coin){
            $coin['wallet'] = Balance::get()->where('user_id', Auth::user()->id)->where('coin_id', $coin->id)->first();
        }

        //check levels
        $users = User::find(Auth::user()->id);
        if($users->points < $settings[4]->value){
            //level 1
            $users->level = 1;
            $users->save();
            $lvl_bonus = 0;
            $next_lvl = $settings[4]->value - $users->points;
            $percent_lvl = (($users->points-$settings[3]->value)*100)/($settings[4]->value-$settings[3]->value);
        }
        else if($users->points >= $settings[4]->value && $users->points < $settings[5]->value){
            //level 2
            $users->level = 2;
            $users->save();
            $lvl_bonus = 1;
            $next_lvl = $settings[5]->value - $users->points;
            $percent_lvl = (($users->points-$settings[4]->value)*100)/($settings[5]->value-$settings[4]->value);
        }
        else if($users->points >= $settings[5]->value && $users->points < $settings[6]->value){
            //level 3
            $users->level = 3;
            $users->save();
            $lvl_bonus = 2;
            $next_lvl = $settings[6]->value - $users->points;
            $percent_lvl = (($users->points-$settings[5]->value)*100)/($settings[6]->value-$settings[5]->value);
        }
        else if($users->points >= $settings[6]->value && $users->points < $settings[7]->value){
            //level 4
            $users->level = 4;
            $users->save();
            $lvl_bonus = 3;
            $next_lvl = $settings[7]->value - $users->points;
            $percent_lvl = (($users->points-$settings[6]->value)*100)/($settings[7]->value-$settings[6]->value);
        }
        else if($users->points >= $settings[7]->value && $users->points < $settings[8]->value){
            //level 5
            $users->level = 5;
            $users->save();
            $lvl_bonus = 4;
            $next_lvl = $settings[8]->value - $users->points;
            $percent_lvl = (($users->points-$settings[7]->value)*100)/($settings[8]->value-$settings[7]->value);
        }
        else if($users->points >= $settings[8]->value && $users->points < $settings[9]->value){
            //level 6
            $users->level = 6;
            $users->save();
            $lvl_bonus = 5;
            $next_lvl = $settings[9]->value - $users->points;
            $percent_lvl = (($users->points-$settings[8]->value)*100)/($settings[9]->value-$settings[8]->value);
        }
        else if($users->points >= $settings[9]->value && $users->points < $settings[10]->value){
            //level 7
            $users->level = 7;
            $users->save();
            $lvl_bonus = 6;
            $next_lvl = $settings[10]->value - $users->points;
            $percent_lvl = (($users->points-$settings[9]->value)*100)/($settings[10]->value-$settings[9]->value);
        }
        else if($users->points >= $settings[10]->value && $users->points < $settings[11]->value){
            //level 8
            $users->level = 8;
            $users->save();
            $lvl_bonus = 7;
            $next_lvl = $settings[11]->value - $users->points;
            $percent_lvl = (($users->points-$settings[10]->value)*100)/($settings[11]->value-$settings[10]->value);
        }
        else if($users->points >= $settings[11]->value && $users->points < $settings[12]->value){
            //level 9
            $users->level = 9;
            $users->save();
            $lvl_bonus = 8;
            $next_lvl = $settings[12]->value - $users->points;
            $percent_lvl = (($users->points-$settings[11]->value)*100)/($settings[12]->value-$settings[11]->value);
        }
        else if($users->points >= $settings[12]->value){
            //level 10
            $users->level = 10;
            $users->save();
            $lvl_bonus = 9;
            $next_lvl = 0;
            $percent_lvl = 0;
        }
    
        return view('dashboard',compact('coins', 'lvl_bonus', 'next_lvl', 'percent_lvl'));
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function updatePassword(Request $request)
    {
        $this->validate($request, [ 
            'oldpassword' => 'required',
            'newpassword' => 'required',
            'newpasswordc' => 'required',
        ]);
 
        $hashedPassword = Auth::user()->password;
        if (\Hash::check($request->oldpassword , $hashedPassword)) {

            if(!($request->newpassword == $request->newpasswordc)){
                session()->flash('error','New password and confirm password doesnt matched');
                return redirect()->back();
            }

            if (\Hash::check($request->newpassword , $hashedPassword)) {
                session()->flash('error','New password can not be the old password!');
                return redirect()->back();
            }
            else{
                $users = User::find(Auth::user()->id);
                $users->password = bcrypt($request->newpassword);
                $users->save();
                session()->flash('success','Password updated successfully');
                //return back()->with('success','Item created successfully!');
                return redirect()->back();
            } 
        }
        else{
            session()->flash('error','Old password doesnt matched');
            return redirect()->back();
        }
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function updateWallets(Request $request)
    {
        $this->validate($request, [ 
            'faucetpay_acc' => 'email',
            'expresscrypto_acc' => 'string',
        ]);

        $users = User::find(Auth::user()->id);
        $users->update($request->all());
        return back()->with('success','Withdrawal settings updated successfully!');

    }

}