<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use App\Models\TicketAnswer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = Ticket::latest()->where('user_id', '=', Auth::user()->id)->paginate(20);
    
        return view('tickets.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('tickets.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'subject' => 'required',
            'description' => 'required',
        ]);

        $requestData = $request->all();
        $requestData['status'] = 'open';
        $requestData['last_answer'] = 'user';
        $requestData['user_id'] = Auth::user()->id;
    
        Ticket::create($requestData);
     
        return redirect()->route('tickets.index')
                        ->with('success','Ticket created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $ticket = Ticket::where('user_id', '=', Auth::user()->id)->find($id);
        if($ticket){
            //$ticketanswer = TicketAnswer::where('ticket_id', '=', $id)->get();
            $ticketanswer = Ticket::find($id)->replies;
            return view('tickets.show',compact('ticket', 'ticketanswer'));
        }
        else
            return redirect()->route('tickets.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function edit(Ticket $ticket)
    {
        //
        return view('tickets.edit',compact('ticket'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Ticket $ticket)
    {
        //
        $request->validate([
            'subject' => 'required',
            'description' => 'required',
        ]);
    
        $ticket->update($request->all());
    
        return redirect()->route('tickets.index')
                        ->with('success','Ticket updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function destroy(Ticket $ticket)
    {
        //
        $ticket->delete();
    
        return redirect()->route('tickets.index')
                        ->with('success','Ticket deleted successfully');
    }
}
