<?php

namespace App\Http\Controllers;

use App\Models\Shortlink;
use App\Models\User;
use App\Models\ShortlinksHistory;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class ShortlinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $links = Shortlink::get();
        $links_count = Shortlink::get()->count();
        foreach($links as $key=>$link){
            $links_visited = ShortlinksHistory::whereDate('created_at', Carbon::today())->where('shortlink_id', $link->id)
                            ->where('user_id', Auth::user()->id)->count();
            $link['visits'] = $links_visited;

            //expire yesterday links
            $expired_links = ShortlinksHistory::whereDate('created_at', '<', Carbon::today())->where('shortlink_id', $link->id)
                                ->where('status', 'pending')->where('user_id', Auth::user()->id)->get();
            if(count($expired_links) > 0){
                foreach($expired_links as $expired){
                    $expired->status = 'expired';
                    $expired->save();
                }
            }

        }

        $tomorrow = Carbon::tomorrow();
        $now = Carbon::now();
        
        $date = $now->diffInHours($tomorrow) . ':' . $now->diff($tomorrow)->format('%I:%S');

        return view('shortlinks.index', compact('links', 'links_count', 'date'));
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function history()
    {
        //
        $links = ShortlinksHistory::latest()->where('user_id', Auth::user()->id)->paginate(20);

        return view('shortlinks.history', compact('links'))
                            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function visit($id)
    {
        //
        $link = Shortlink::find($id);
        if($link){

            $links_visited = ShortlinksHistory::whereDate('created_at', Carbon::today())->where('shortlink_id', $link->id)
                            ->where('user_id', Auth::user()->id)->count();

            if($links_visited < $link->views){

                $randomString = Str::random(30);
                $siteurl = url('')."/dashboard/shortlinks/visited/".$randomString;
                //$siteurl = "https://domain.com/dashboard/shortlinks/visited/".$randomString;
                $long_url = urlencode($siteurl);
                $api_token = $link->api_key;
                $url = urldecode($link->url);
                $api_url = $url."/api?api={$api_token}&url={$long_url}";
                $result = @json_decode(file_get_contents($api_url),TRUE);
                if($result["status"] === 'error') {
                    return redirect()->back()
                                    ->with('error','An error was found.');
                } else {
                    ShortlinksHistory::create([
                        'energy' => $link->energy, 
                        'shortlink_id' => $link->id,
                        'user_id' => Auth::user()->id, 
                        'status' => 'pending',
                        'verify_code' => $randomString
                    ]);
                    return redirect()->away($result["shortenedUrl"]);
                }

            }else{
                return redirect()->back()
                                    ->with('error','Limit for this shortlink exceeded.');
            }

        }else{
            return redirect()->back()
                                    ->with('error','An error was found.');
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function visited($verify_code)
    {
        //
        $link = ShortlinksHistory::whereDate('created_at', Carbon::today())->where('status', 'pending')
                    ->where('verify_code', $verify_code)->where('user_id', Auth::user()->id)->get();
        if(count($link) > 0){

            $user = User::find($link[0]->user_id);
            $link[0]->status = 'completed';
            $link[0]->save();

            $user->energy += $link[0]->energy;
            $user->points += $link[0]->shortlink->points;
            $user->save();

            return redirect()->route('shortlinks.index')
                                    ->with('success', $link[0]->energy.' Energy added to your account');

        }else{
            return redirect()->route('shortlinks.index')
                                    ->with('error','Verify code not found or already visited.');
        }
    }

}
