<?php

namespace App\Http\Controllers;

use App\Models\Autoclaim;
use App\Models\AutoclaimsHistory;
use App\Models\Coin;
use App\Models\Balance;
use App\Models\User;
use App\Models\Referral;
use App\Models\Settings;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Response;

class AutoclaimController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $expired_autoclaim = Autoclaim::where('status', 'running')
                                ->where('user_id', Auth::user()->id)->get();
        if(count($expired_autoclaim) > 0){
                foreach($expired_autoclaim as $expired){
                    $expired->status = 'expired';
                    $expired->save();
                }
        }

        $coins = Coin::get()->where('faucet_active', 1);
        return view('autoclaim.index',compact('coins'));
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function history()
    {
        //
        //$autoclaims = User::find(Auth::user()->id)->autoclaims()->find(2)->history;
        $autoclaims = User::find(Auth::user()->id)->history()->paginate(20);

        return view('autoclaim.history', compact('autoclaims'))
                            ->with('i', (request()->input('page', 1) - 1) * 20);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'currencies' => 'required',
            'frequency' => 'required|in:1,2,3',
            'boost' => 'required|in:1,2,3,4',
        ]);

        $requestData = $request->all();

        $currencies = $requestData['currencies'];
        $frequency = $requestData['frequency'];
        $boost = $requestData['boost'];
        
        foreach($currencies as $key=>$currency){
            $energy = 0;
            $coin = Coin::where('short_name', strtolower($currency))->first();
            if($coin){
                $saveData['user_id'] = Auth::user()->id;
                $saveData['coin_id'] = $coin->id;
                $saveData['frequency'] = $frequency;
                $saveData['boost'] = $boost;
                $saveData['status'] = 'running';
                $energy = $energy + ($coin->consume_energy*$boost);
                
                if(Auth::user()->energy >= $energy){
                    Autoclaim::create($saveData);
                }else{
                    return redirect()->back()
                                ->with('error','Insufficient account energy.');
                }
            }
        }

        return redirect()->route('autoclaim.start');

        /*if(Auth::user()->energy >= $total_energy){
            Autoclaim::create($saveData);
            return redirect()->route('autoclaim.start');
        }else{
            return redirect()->back()
                                ->with('error','Insufficient account energy.');
        }*/

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function start()
    {
        //
        return view('autoclaim.start');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function service()
    {
        //
        $autoclaims = Autoclaim::get()->where('user_id', Auth::user()->id)->where('status', 'running');
        $reward = 0;
        $energy = 0;

        if(count($autoclaims) > 0){
            foreach($autoclaims as $autoclaim){

                if($autoclaim->frequency == 1){
                    $bonusper = 0;
                }else if($autoclaim->frequency == 2){
                    $bonusper = 1;
                }else if($autoclaim->frequency == 3){
                    $bonusper = 2;
                }

                $reward = $reward + ($autoclaim->coin->reward_amount*$autoclaim->boost);
                //need add bonus to reward
                $bonus = ($reward/100)*$bonusper;

                $reward = number_format($reward+$bonus, 8, '.', '');
                $energy = $energy + ($autoclaim->coin->consume_energy*$autoclaim->boost);
            }

            if(Auth::user()->energy >= $energy){

                $users = User::find(Auth::user()->id);
                
                foreach($autoclaims as $autoclaim){

                    //last claim check

                    if($autoclaim->frequency == 1){
                        $seconds = 120;
                        $bonusper = 0;
                    }else if($autoclaim->frequency == 2){
                        $seconds = 300;
                        $bonusper = 1;
                    }else if($autoclaim->frequency == 3){
                        $seconds = 600;
                        $bonusper = 2;
                    }

                    $last_claim = Auth::user()->last_autoclaim;
                    if($last_claim != NULL){
                        $last_claim = strtotime($last_claim);
                    }else{
                        $last_claim = 0;
                    }

                    $date = Carbon::parse($last_claim)
                    ->addSeconds($seconds);

                    $nowtime = Carbon::now();

                    if($nowtime > $date){
                        //bonus by type
                        $bonus = ($autoclaim->coin->reward_amount/100)*$bonusper;
                        $bonus = number_format($bonus, 8, '.', '');

                        //bonus by level
                        $bonuslvlpercentage = Auth::user()->level-1;
                        $bonuslvl = ($autoclaim->coin->reward_amount/100)*$bonuslvlpercentage;
                        $bonus = $bonus + $bonuslvl;
                        $bonus = number_format($bonus, 8, '.', '');

                        $saveData['energy'] = $autoclaim->coin->consume_energy*$autoclaim->boost;
                        $saveData['claimed'] = $autoclaim->coin->reward_amount*$autoclaim->boost;
                        $saveData['claimed'] = number_format($saveData['claimed']+$bonus, 8, '.', '');
                        $saveData['autoclaim_id'] = $autoclaim->id;

                        $wallet = Balance::where('user_id', Auth::user()->id)->where('coin_id', $autoclaim->coin->id)->first();
                        if($wallet){
                            //printf($wallet);
                            $wallet->balance += $saveData['claimed'];
                            $wallet->save();
                        }else{
                            $balanceData['balance'] = $saveData['claimed'];
                            $balanceData['user_id'] = Auth::user()->id;
                            $balanceData['coin_id'] = $autoclaim->coin->id;
                            Balance::create($balanceData);
                        }

                        $users->energy -= $saveData['energy'];
                        $users->last_autoclaim = $nowtime;
                        $users->save();

                        AutoclaimsHistory::create($saveData);

                        //if user have referral
                        $referral = Referral::where('refers_to', Auth::user()->id)->first();
                        if($referral){
                            $ref_earning = Settings::where('name', 'referral_earning')->first();
                            $bonusref = ($autoclaim->coin->reward_amount/100)*$ref_earning->value;
                            $bonusref = number_format($bonusref, 8, '.', '');

                            $wallet_ref = Balance::where('user_id', $referral->referred_by)->where('coin_id', $autoclaim->coin->id)->first();
                            if($wallet_ref){
                                $wallet_ref->balance += $bonusref;
                                $wallet_ref->save();
                            }else{
                                $balanceData['balance'] = $bonusref;
                                $balanceData['user_id'] = $referral->referred_by;
                                $balanceData['coin_id'] = $autoclaim->coin->id;
                                Balance::create($balanceData);
                            }
                        }

                        /*return response()
                                ->json(['seconds' => $seconds, 'message' => 'ok', 'amount' => $saveData['claimed'], 'coin' => $autoclaim->coin->short_name])
                                ->header('Content-Type', 'application/json');*/

                    }else{

                        $diff = $date->diffInSeconds($nowtime); 
                        return response()
                                ->json(['seconds' => $diff, 'message' => 'time'])
                                ->header('Content-Type', 'application/json');
                    }

                }

                return response()
                            ->json(['seconds' => $seconds, 'message' => 'ok', 'amount' => 1, 'coin' => 'test', 'detail' => 'Rewards added to your account.'])
                            ->header('Content-Type', 'application/json');
                
            }else{

                foreach($autoclaims as $autoclaim){
                    $autoclaim->status = 'completed';
                    $autoclaim->save();
                }

                return response()
                        ->json(['seconds' => 0, 'message' => 'energy'])
                        ->header('Content-Type', 'application/json');
                
            }
        }else{
            return response()
                        ->json(['seconds' => 0, 'message' => 'no_autoclaims'])
                        ->header('Content-Type', 'application/json');
        }

    }

}
